`timescale 100 ps/100 ps
module CCU2 (
  A0,
  B0,
  C0,
  D0,
  A1,
  B1,
  C1,
  D1,
  CIN,
  COUT,
  S0,
  S1
)
;
input A0 ;
input B0 ;
input C0 ;
input D0 ;
input A1 ;
input B1 ;
input C1 ;
input D1 ;
input CIN ;
output COUT ;
output S0 ;
output S1 ;
parameter INIT0="0x0000";
parameter INIT1="0x0000";
parameter INJECT="NO";
endmodule /* CCU2 */

(* black_box_pad_pin="TDI,TCK,TMS,TDO" *)module JTAGH19 (
  TCK,
  TMS,
  TDI,
  TDO,
  JTDI,
  JTCK,
  JSHIFT,
  JUPDATE,
  JRSTN,
  JCE2,
  CDN,
  IP_ENABLE,
  ER2_TDO
)
;
input TCK ;
input TMS ;
input TDI ;
output TDO ;
output JTDI ;
output JTCK ;
output JSHIFT ;
output JUPDATE ;
output JRSTN ;
output JCE2 ;
output CDN ;
output [18:0] IP_ENABLE ;
input [18:0] ER2_TDO ;
endmodule /* JTAGH19 */

module PDP16K (
  DI,
  ADW,
  ADR,
  CLKW,
  CLKR,
  CEW,
  CSW,
  CSR,
  CER,
  RST,
  DO,
  ONEBITERR,
  TWOBITERR
)
;
input [35:0] DI ;
input [13:0] ADW ;
input [13:0] ADR ;
input CLKW ;
input CLKR ;
input CEW ;
input [2:0] CSW ;
input [2:0] CSR ;
input CER ;
input RST ;
output [35:0] DO ;
output ONEBITERR ;
output TWOBITERR ;
parameter DATA_WIDTH_W="X36";
parameter DATA_WIDTH_R="X36";
parameter OUTREG="BYPASSED";
parameter ECC="DISABLED";
parameter RESETMODE="SYNC";
parameter ASYNC_RST_RELEASE="ASYNC";
parameter CSDECODE_W="000";
parameter CSDECODE_R="000";
parameter GSR="ENABLED";
parameter INITVAL_00="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_01="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_02="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_03="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_04="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_05="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_06="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_07="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_08="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_09="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_10="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_11="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_12="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_13="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_14="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_15="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_16="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_17="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_18="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_19="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_20="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_21="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_22="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_23="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_24="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_25="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_26="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_27="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_28="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_29="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_30="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_31="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_32="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_33="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_34="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_35="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_36="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_37="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_38="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_39="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
endmodule /* PDP16K */

module OSCA (
  HFOUTEN,
  HFSDSCEN,
  HFCLKOUT,
  LFCLKOUT,
  HFCLKCFG,
  HFSDCOUT
)
;
input HFOUTEN ;
input HFSDSCEN ;
output HFCLKOUT ;
output LFCLKOUT ;
output HFCLKCFG ;
output HFSDCOUT ;
endmodule /* OSCA */

