--
-- Synopsys
-- Vhdl wrapper for top level design, written on Wed Dec 27 09:21:12 2023
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity wrapper_for_presubmult is
   port (
      clk : in std_logic;
      rst : in std_logic;
      ain : in std_logic_vector(11 downto 0);
      bin : in std_logic_vector(15 downto 0);
      cin : in std_logic_vector(15 downto 0);
      pout : out std_logic_vector(32 downto 0)
   );
end wrapper_for_presubmult;

architecture rtl of wrapper_for_presubmult is

component presubmult
 port (
   clk : in std_logic;
   rst : in std_logic;
   ain : in std_logic_vector (11 downto 0);
   bin : in std_logic_vector (15 downto 0);
   cin : in std_logic_vector (15 downto 0);
   pout : out std_logic_vector (32 downto 0)
 );
end component;

signal tmp_clk : std_logic;
signal tmp_rst : std_logic;
signal tmp_ain : std_logic_vector (11 downto 0);
signal tmp_bin : std_logic_vector (15 downto 0);
signal tmp_cin : std_logic_vector (15 downto 0);
signal tmp_pout : std_logic_vector (32 downto 0);

begin

tmp_clk <= clk;

tmp_rst <= rst;

tmp_ain <= ain;

tmp_bin <= bin;

tmp_cin <= cin;

pout <= tmp_pout;



u1:   presubmult port map (
		clk => tmp_clk,
		rst => tmp_rst,
		ain => tmp_ain,
		bin => tmp_bin,
		cin => tmp_cin,
		pout => tmp_pout
       );
end rtl;
