#-- Lattice Semiconductor Corporation Ltd.
#-- Synplify OEM project file

#device options
set_option -technology LFCPNX
set_option -part LFCPNX_100
set_option -package LFG672C
set_option -speed_grade -9
#compilation/mapping options
set_option -symbolic_fsm_compiler true
set_option -resource_sharing true

#use verilog standard option
set_option -vlog_std v2001

#map options
set_option -frequency 1
set_option -maxfan 1000
set_option -auto_constrain_io 0
set_option -retiming false; set_option -pipe true
set_option -force_gsr auto
set_option -compiler_compatible 0
set_option -frequency 1

set_option -default_enum_encoding default

#timing analysis options



#automatic place and route (vendor) options
set_option -write_apr_constraint 1

#synplifyPro options
set_option -fix_gated_and_generated_clocks 0
set_option -update_models_cp 0
set_option -resolve_multiple_driver 0


set_option -rw_check_on_ram 0
set_option -seqshift_no_replicate 0

#-- set any command lines input by customer

set_option -dup 1
set_option -disable_io_insertion false
add_file -constraint {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/source/imp1/timingsdc.sdc}
add_file -verilog {C:/lscc/radiant/2023.1/ip/pmi/pmi_lfcpnx.v}
add_file -vhdl -lib pmi {C:/lscc/radiant/2023.1/ip/pmi/pmi_lfcpnx.vhd}
add_file -verilog "C:/lscc/radiant/2023.1/data/reveal/src/ertl/ertl.v"
add_file -verilog {C:/lscc/radiant/2023.1/data/reveal/src/ertl/JTAG_SOFT.v}
add_file -verilog  -vlog_std v2001 {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/imp1/reveal_workspace/tmpreveal/top_la0_trig_gen.v}
add_file -verilog  -vlog_std v2001 {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/imp1/reveal_workspace/tmpreveal/top_la0_gen.v}
add_file -vhdl -lib "work" {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/imp1/reveal_workspace/tmpreveal/reveal_coretop.vhd}
add_file -vhdl -lib "work" {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/imp1/reveal_workspace/tmpreveal/mysettings.vhd}
add_file -vhdl -lib "work" {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/imp1/reveal_workspace/tmpreveal/ce_sync_uniq_0.vhd}
add_file -vhdl -lib "work" {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/imp1/reveal_workspace/tmpreveal/cnt_uniq_0.vhd}
add_file -vhdl -lib "work" {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/imp1/reveal_workspace/tmpreveal/cnt_uniq_1.vhd}
add_file -vhdl -lib "work" {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/imp1/reveal_workspace/tmpreveal/cnt_uniq_2.vhd}
add_file -vhdl -lib "work" {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/imp1/reveal_workspace/tmpreveal/cnt_uniq_3.vhd}
add_file -vhdl -lib "work" {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/imp1/reveal_workspace/tmpreveal/top.vhd}
add_file -constraint {C:/lscc/radiant/2023.1/data/reveal/src/ertl/reveal_constraint.sdc} 
#-- top module name
set_option -top_module Top
set_option -include_path {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST}

#-- run Synplify with 'arrange HDL file'
project -run hdl_info_gen -fileorder

#-- set result format/file last
project -result_format "vm"
project -result_file {D:/02_LSCC/09_GSR/Final/LAB02_Prop_Circuit_ARST/imp1/LAB04_imp1.vm}

#-- error message log file
project -log_file {LAB04_imp1.srf}
project -run -clean
