 library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_SIGNED.all;
use work.Mysettings.all;


entity Top is 	  
    port ( 
        reset, G_reset, CLK1, clk2 : in std_logic;
        LED1,LED2 :out std_logic
       );
end Top;

architecture behave of Top is 

Component Reset_Sync
port (
clk, A_Rst : in std_logic;
Rst_Sync : out std_logic 
);
end component;

Component GSR  
		Port ( GSR_N : in std_logic;
			CLK : in std_logic);
end component;
----------- CNT component --------------
Component CNT is
generic ( CNT_WIDTH : natural);  
port (
clk, rst: in std_logic;
Cout : out std_logic_vector((CNT_WIDTH-1) downto 0)
);
end component;

------------ Signal declaration ----------------
signal CNT1 : std_logic_vector(Width1-1 downto 0);
signal CNT2 : std_logic_vector(Width2-1 downto 0);

signal rst1,rst2 : std_logic;

attribute syn_preserve : boolean;
attribute syn_preserve of CNT: component is true;

begin 
-------------------------------------------------
--        	     Reset Generation			----
-------------------------------------------------
-- using GSR Component 
GSR_INST : GSR  port map (G_reset, CLK1);
-------------------------------------------------
RST001 : Reset_Sync 
port map(
		clk 		=> clk1, 
		A_Rst 		=> reset, 
		Rst_Sync 	=> rst1
);

RST002 : Reset_Sync 
port map(
		clk 		=> clk2, 
		A_Rst 		=> reset, 
		Rst_Sync 	=> rst2
);
-------------------------------------------------
--************************************************-

CNT01: CNT 
generic map( CNT_WIDTH => Width1)  -- Width of counter 
port map(
    clk => clk1,
    rst => rst1,
    cout => CNT1
);

CNT02: CNT 
generic map( CNT_WIDTH => Width2)  -- Width of counter 
port map(
    clk => clk2,
    rst => rst2,
    cout => CNT2
);

process (clk1)
begin
	if rising_edge(clk1) then
		if rst1 ='0' then 
			LED1 <= '0';
		else 
			LED1 <= CNT1(0) xor CNT1 (Width1-1);
		end if;
	end if;
end process;

process (clk2)
begin
	if rising_edge(clk2) then
		if rst2 ='0' then 
			LED2 <= '0';
		else 
			LED2 <= CNT2(0) xor CNT2 (Width2-1);
		end if;
	end if;
end process;
end architecture behave;